Imports System.IO.Ports
Imports USGLib

Public Class Form1

    Dim usg As New USGLib.USGClass

    Private Sub Form1_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        InitializeForm()
    End Sub

    Sub InitializeForm()
        'Handle USGLib DLL Exception By Self
        usg.SetHandleExceptionSelf(True)

        'Initial Get PortList
        Dim portList() As String
        portList = SerialPort.GetPortNames
        Array.Sort(portList)
        cmbPorts.DataSource = portList
        cmbPorts.DropDownStyle = ComboBoxStyle.DropDownList
        ' Select a default port.
        If portList.Length() > 0 Then
            cmbPorts.SelectedIndex = 0
        Else
            cmbPorts.SelectedIndex = -1
        End If

    End Sub

    Private Sub sendBtn_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles sendBtn.Click
        Try
            usg.SetFreq(Me.freqText.Text)
            usg.SetPowerLevel(Me.powerText.Text)
        Catch ex As Exception
            MessageBox.Show(ex.Message)
        End Try

    End Sub

    Private Sub initBtn_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles initBtn.Click
        Try
            usg.Initial()
        Catch ex As Exception
            MessageBox.Show(ex.Message)
        End Try
    End Sub



    Private Sub Form1_FormClosing(ByVal sender As Object, ByVal e As System.Windows.Forms.FormClosingEventArgs) Handles Me.FormClosing

        Try
            usg.CloseDevice()
        Catch ex As Exception
            MessageBox.Show(ex.Message)
        End Try

    End Sub

    Private Sub openBtn_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles openBtn.Click

        Try
            usg.OpenDevice(cmbPorts.Text)
        Catch ex As Exception
            MessageBox.Show(ex.Message)
        End Try

    End Sub
End Class
